//Q&A checkbox with custom feedback (form_number, element_name, hint_boolean=default:false, individual_feedback=default:true)
function form_check_custom_feedback(form_number,element_name,hint_boolean,individual_feedback) {
    //defining the form
    var myform = document.forms['form'+form_number]
    //defining the checkboxes in the form
    var elements = myform[element_name]
    var answersChecked = false //assuming nothing is checked
    var counter_correct = 0
    var counter_incorrect = 0
    //searching for checked answers
    for (i1=0;i1<elements.length;i1++) {
        if (elements[i1].checked) {
            //alert('I found one!')
            //checked turns true when at least one checked answer found
            answersChecked = true;
            //
            myform.getElementsByClassName('feedback')[i1+1].style.display = "block"
            //counting the number of selected answers that are correct
            if (elements[i1].value == 't') {
              counter_correct += 1;
            } else {
              counter_incorrect += 1
            }
        }
    }
    if (answersChecked) {
      //display the message 'After going through...'
      myform.getElementsByClassName('feedback')[0].style.display = "block"
      //hint at the end of the feedback if hint_boolean='true'
      if (hint_boolean) {
        var hint_element = myform.getElementsByClassName('feedback')[myform.getElementsByClassName('feedback').length-1]
        var hint_feedback_text = "<strong>There are 3 correct answers!</strong> You have selected <strong>"+counter_correct+"</strong> correct answer(s)."+
        "<br>If you have selected <strong><u>all</u></strong> the necessary warnings, you can lean back for a moment now and wait until your shift is over. A brief overview about your shift and the past hours will be provided afterwards."+
        "<br>Otherwise, please check your answers."
        hint_element.innerHTML = hint_feedback_text
        hint_element.style.display = "block"
      }
      if (!individual_feedback) {
        if (counter_correct > 0 && counter_incorrect > 0) {
          document.getElementsByClassName('correct_feedback')[0].style.display = "block"
          document.getElementsByClassName('incorrect_feedback')[0].style.display = "block"
        } else if (counter_correct > 0 && counter_incorrect == 0) {
          document.getElementsByClassName('correct_feedback')[0].style.display = "block"
        } else if (counter_correct == 0 && counter_incorrect > 0) {
          document.getElementsByClassName('incorrect_feedback')[0].style.display = "block"
        }
      }
      //OPTIONAL!!
      document.getElementById('summary_button').style.display = "block"
      ////////////
    } else {
        alert('Select your answers!')
    }
}

/*<div class="question_wrap">

        <h3>Issue warning</h3>
        <p class="question"><br><br>Please choose for what time you would issue a warning:</p>

        <form id="form1">
          <div style="margin-left:60px">
            <table class="check_table">
              <tr>
                <td><input type="checkbox" name="warning1" value="f" autocomplete="off">a) None.</td>
              </tr>
              <tr>
                <td><input type="checkbox" name="warning1" value="f" autocomplete="off">b) 3 o'clock</td>
              </tr>
            </table>
            <br>
            <input type="button" name="submit" value="Submit" onclick="form_check_custom_feedback(1,'warning1',true, false)">
            <input type="button" name="retry" value="Retry" onclick="location.reload()">
          </div>
          <div class="feedback"><strong>After going through the material again, you realize that:</strong></div>
          <div id="answer1" class="feedback"><strong>Individual feedback.</strong></div>
          <div id="answer2" class="feedback"><strong>Individual feedback.</strong></div>
          
          <!--When only individual feedback present, the 2 lower divs are unnecessary-->
          <div class="correct_feedback feedback"><strong>Feedback for the correct answer(s): Non-individual feedback.<br></div>
          <div class="incorrect_feedback feedback"><strong>Feedback for the incorrect answer(s): Non-individual feedback.</div><br>
          <!-Div for the hint_feedback-->
          <div id="hint_feedback" class="feedback"></div>
        </form><br><br>
        <!-- end answer -->

      </div>
      <!-- end checkbox interaction -->*/


//function for evaluation checkbox questions in a form, the input is the form number/name
function form_check_questions1(form_number,element_name,show_input) {
    var show_user_input = false || show_input
    //defining the form
    var myform = document.forms['form'+form_number]
    //defining the checkboxes of the form
    var checks = myform[element_name]
    //console.log(checks)
    var answersChecked = false //assuming nothing is checked
    //searching for checked answers
    for (i1=0;i1<checks.length;i1++) {
        if (checks[i1].checked) {
            //alert('I found one!')
            answersChecked = true;
            break
        }
    }
    //if there is something checked show the correct answers and the feedback
    if (answersChecked) {
        //display the message of the feedback
        //if show user input = true, show the selected answers
        if (show_user_input) {
          var warning_decision = "<strong>Your decision:</strong><br>"
          for (i2=0;i2<checks.length;i2++) {
            if (checks[i2].checked) {
              myform.getElementsByTagName('td')[i2+3].style.borderRadius = "10px"
              myform.getElementsByTagName('td')[i2+3].style.background = "#86b7fc"
              warning_decision += checks[i2].value + ' '
            }
          }
          warning_decision += '<br>Keep this window <strong>open</strong> so you can compare your other tasks to this first guess!'
          //console.log(warning_decision)
          myform.getElementsByClassName('feedback')[0].innerHTML = warning_decision
          myform.getElementsByClassName('feedback')[0].style.display = "block";
        } else {
          //if show user input = false, show the correct answers
          //mark all the correct answers by changin the color of their background
          var corr_answers = myform.getElementsByClassName('correct');
          for (i1=0;i1<corr_answers.length;i1++) {
              corr_answers[i1].style.background = "#d4f3ca"
          }
          myform.getElementsByClassName('feedback')[0].style.display = "block";
        }
        var next = form_number+1
        if (document.getElementById('div'+next) != undefined || document.getElementById('div'+next) != null) {
          document.getElementById('div'+next).style.display = "block";
        }
        //console.log('Checked')
    } else { //if nothing is checked alert the user
        alert('Select an answer')
    }
}

/*<div class="question_wrap">
        <h3>Question 1</h3>
        <p class="question"><br><br>Question text</p>

          <form id="form1">
            <div style="margin-left:60px">
              <table class="checkbox_table">
                <tr>
                  <td><strong>Label1</strong></td>
                  <td><strong>Label2</strong></td>
                  <td><strong>Label3</strong></td>
                </tr>
                <tr>
                  <td><input type="checkbox" name="issue_warning" value="m20">a)</td>
                  <td><input type="checkbox" name="issue_warning" value="v20">b)</td>
                  <td><input type="checkbox" name="issue_warning" value="s20">c)</td>
                </tr>
                <tr>
                  <td><input type="checkbox" name="issue_warning" value="m21">d)</td>
                  <td><input type="checkbox" name="issue_warning" value="v21">e)</td>
                  <td class="correct"><input type="checkbox" name="issue_warning" value="s21">f)</td>
                </tr>
              </table>
              <br>
              <input type="button" value="Submit" onclick="form_checkbox_questions(1)">
            </div>
            <div class="feedback"><strong>The correct answer(s) is/are:</strong> Label3 f)<br></div>
          </form>

          <!-- end answer -->
      </div>
      <!-- end checkbox interaction -->*/


//function for evaluation checkbox/radio questions in a form, while questions appear and disappear when answered after pressing 'Next', the input is the form number/name
function form_check_questions2(form_number,element_name,show_input) {
    var show_user_input = false || show_input
    //defining the form
    var myform = document.forms['form'+form_number]
    //defining the checkboxes of the form
    var checks = myform[element_name]
    //console.log(checks)
    var answersChecked = false //assuming nothing is checked
    //searching for checked answers
    for (i1=0;i1<checks.length;i1++) {
        if (checks[i1].checked) {
            //alert('I found one!')
            answersChecked = true;
            break
        }
    }
    //if there is something checked show the correct answers and the feedback
    if (answersChecked) {
        //display the message of the feedback
        //if show user input = true, show the selected answers
        if (show_user_input) {
          var warning_decision = "<strong>Your decision:</strong><br>"
          for (i2=0;i2<checks.length;i2++) {
            if (checks[i2].checked) {
              myform.getElementsByTagName('td')[i2+3].style.borderRadius = "10px"
              myform.getElementsByTagName('td')[i2+3].style.background = "#86b7fc"
              warning_decision += checks[i2].value + ' '
            }
          }
          warning_decision += '<br>Keep this window <strong>open</strong> so you can compare your other tasks to this first guess!'
          //console.log(warning_decision)
          myform.getElementsByClassName('feedback')[0].innerHTML = warning_decision
          myform.getElementsByClassName('feedback')[0].style.display = "block";
        } else {
          //if show user input = false, show the correct answers
          //mark all the correct answers by changin the color of their background
          var corr_answers = myform.getElementsByClassName('correct');
          for (i1=0;i1<corr_answers.length;i1++) {
              corr_answers[i1].style.background = "#d4f3ca"
          }
          myform.getElementsByClassName('feedback')[0].style.display = "block";

          var next_btn = myform.getElementsByClassName('next_btn')[0];
          var next_form_number = form_number+1;
          next_btn.onclick = function() {
            document.getElementById('div'+form_number).style.display = "none";
            document.getElementById('div'+next_form_number).style.display = "block";
          }

          next_btn.style.visibility = "visible";
        }
        //console.log('Checked')
    } else { //if nothing is checked alert the user
        alert('Select an answer')
    }
}

/*<div class="question_wrap">
  <h3>Question</h3>
  <p class="question">Connect the concept with its description.</p>

  <div id="div8" style="display:none">
    <p>Curve or surface determined by a temperature that equals an ignition temeprature. It can be characterized by leading and rear edges. Also known as fire line or fireline. - fire front</p>
    <form id="form8">
      <div style="margin-left:60px">
        <table>
          <tr>
            <td class="correct"><input type="radio" name="ex8" autocomplete="off">a) Fire Front</td>
          </tr>
          <tr>
            <td><input type="radio" name="ex8" autocomplete="off">b) Rate of spread</td>
          </tr>
          <tr>
            <td><input type="radio" name="ex8" autocomplete="off">c) Surface Fire</td>
          </tr>
        </table>
        <br>
        <input type="button" value="Submit" onclick="form_check_questions(8,'ex8')"><input style="visibility:hidden" type="button" class="next_btn" value="Next">
      </div>
      <div class="feedback"><strong>The correct answer is:</strong> a) Fire Front.<br></div>
    </form><br>
  </div>

  <div id="div9" style="display:none">
    <p>Forward movement of the fire front per unit time after having reached an equilibrium state. It can be measured in metres/minute and may range up to around 30 metres/minute. - rate of spread</p>
    <form id="form9">
      <div style="margin-left:60px">
        <table>
          <tr>
            <td class="correct"><input type="radio" name="ex9" autocomplete="off">a) Rate of spread</td>
          </tr>
          <tr>
            <td><input type="radio" name="ex9" autocomplete="off">b) Surface Fire</td>
          </tr>
        </table>
        <br>
        <input type="button" value="Submit" onclick="form_check_questions(9,'ex9')">
      </div>
      <div class="feedback"><strong>The correct answer is:</strong> a) Fire Front.<br><br>In the end a <strong>surface fire</strong> is a forest fire that burns only the surface litter and undergorth. A forest fire up to a certain rate of spread, in which crowns are not involved.</div>
    </form><br>
  </div>

</div>*/


/*Checks only if any answers have been selected from a drop down list*/
function dropdown_simple_check(formId){
  var myform = document.querySelector('#'+formId);
  var droplists = myform.getElementsByClassName('droplist');

  var answer_selected = true;
  for (i1=0;i1<droplists.length;i1++){
    /*the default selection at the beginning is the 'none' selection and if it stays so, the loop breaks*/
    if (droplists[i1].value == 'none'){
      answer_selected = false;
      break
    }
  }

  if (answer_selected){ /*if all the answers have been selected the feedback is shown and the submit button is hidden*/
    document.getElementsByClassName('feedback')[0].style.display = 'block';
    document.getElementsByClassName('submitButton')[0].style.display = 'none';
  } else { /*if nothing selected, prompts the user to select the answers of the questions*/
    alert('Select all the answers!')
  }
}

/*<div class="question_wrap">
    <h3>Question</h3>
    <p class="question">Let's consider a simplified example with MODIS passes from 3 consecutive days over the areas A, B and C. 
    For each of these days the algorithm's first-stage detection derives "no scar" or "scar candidate" for the specific area as seen below. 
    Can you now connect each class to its corresponding area?</p>
    <form id="form1">
      <table>
        <tr>
          <th></th>
          <th>Day 1</th>
          <th>Day 2</th>
          <th>Day 3</th>
          <th>Algorithm result</th>
        </tr>
        <tr>
          <th>Area A</th>
          <td>No scar</td>
          <td>Scar candidate</td>
          <td>Scar candidate</td>
          <td>
            <select class="droplist" id="q1">
                      <option value="none" selected="selected">-</option>
                      <option>a) Burnt area</option>
                      <option>b) Cloud shadow</option>
                      <option>d) Scarfree</option>
                  </select>
          </td>
        </tr>
        <tr>
          <th>Area B</th>
          <td>No scar</td>
          <td>No scar</td>
          <td>No scar</td>
          <td>
            <select class="droplist" id="q2">
                      <option value="none" selected="selected">-</option>
                      <option>a) Burnt area</option>
                      <option>b) Cloud shadow</option>
                      <option>d) Scarfree</option>
                  </select>           
          </td>
        </tr>
        <tr>
          <th>Area C</th>
          <td>No scar</td>
          <td>Scar candidate</td>
          <td>No scar</td>
          <td>
            <select class="droplist" id="q3">
                      <option value="none" selected="selected">-</option>
                      <option>a) Burnt area</option>
                      <option>b) Cloud shadow</option>
                      <option>d) Scarfree</option>
                  </select>           
          </td>
        </tr>
      </table>
      <input class="submitButton" type="button" value="Submit" onclick="dropdown_simple_check('form1')">
      <div class="feedback"><strong>The correct answers are:</strong><br>Area A -> Burnt area; Area B -> Scarfree; Area C -> Cloud Shadow</div>
    </form>
  </div>*/


/*Filling the sentence gaps, checks how many corrects answers there are and tell 'Correct' if all true*/
function sentence_dropdown(formId){
    var myform = document.querySelector('#'+formId);
    var counter = 0;
    var selection = myform.getElementsByTagName('select');
    var selected = true;

    for (i=0;i<selection.length;i++){
      if (selection[i].value == 'none'){
        selected = false;
        break
      } else if (selection[i].value == 't'){
          counter += 1;
      }
    }

    if (!selected) {
      alert('Choose all the answers!');
    } else {
      document.getElementsByClassName('feedback')[0].style.display = "block";
      if (counter != selection.length){
        document.getElementsByClassName('feedback')[0].innerHTML = "<strong>"+counter+"  answers are correct</strong><br><br><input type='button' value='Retry' onclick='location.reload()'>";
      } else if (counter == selection.length){
        document.getElementsByClassName('feedback')[0].innerHTML = "<strong>Correct!</strong>"
      }
    }
  }

/*<div class="question_wrap">
  <form id="form1">
    <p style="line-height:25px;">Water clouds occur when the temperature is above zero and the dew point depression is 
      <select class="droplist1">
        <option value="none">(choose one)</option>
        <option value="t">0 &deg;C</option>
        <option>0...1 &deg;C</option>
      </select>. 
    Mixed snow and water clouds occur when the 
    <select class="droplist2">
      <option value="none">(choose one)</option>
      <option>temperature is between 0 &deg;C and -10 &deg;C</option>
      <option value="t">dew point depression is 0...1 &deg;C</option>
    </select>. 
    Supercooled water clouds occur when the temperature is 
    <select class="droplist3">
      <option value="none">(choose one)</option>
      <option value="t">below zero and the dew point depression is 0 &deg;C</option>
      <option>0...-12 &deg;C and the dew point depression is 0...1 &deg;C</option>
    </select>. 
    Snow and ice clouds are present when the 
    <select class="droplist4">
      <option value="none">(choose one)</option>
      <option>temperature is below -15 &deg;C</option>
      <option value="t">dew point depression is 1...4 &deg;C</option>
    </select>.</p>
    <p class="input"><input type="button" value="Submit" onclick="sentence_dropdown('form1')"></p>
    <p class="feedback"></p>
  </form>
</div>*/


//function for evaluating the checkbox questions, the input is the question number
function checkbox_question(q_num) {

    //checking if any answer is selected
    //defining options of the checkbox
    var options = document.getElementsByName('q'+q_num);

    //setting the starting assumption, nothing is selected
    var answers_checked = false;
    //going through the checkboxes, searching for checked items
    for (i1=1;i1<options.length+1;i1++) {
        if (options[i1-1].checked) {
            answers_checked = true; //if anything checked, the starting assumption is changing to True -> something is checked
            break //exiting the loop
        }
    }
    //if there is something checked, show the correct answers and the feedback
    if (answers_checked) {
        var answers = document.getElementsByClassName('option'+q_num+' correct'); //grabbing all elements with the class name "option" and "correct"
        for (i2=0;i2<answers.length;i2++) {
            answers[i2].style.background = '#d4f3ca' //changing the background color of the correct items
        }
        document.getElementById('feedback'+q_num).style.display = 'block'; //displaying the feedback to the answers
    //if there is nothing checked, alert the user!
    } else {
        alert('Select an answer!')
    }
}

/*<div class="quiz_wrap">

    <p><strong>Quiz example:</strong></p>

    <div class="question_wrap">

        <p><strong>Question 1:</strong></p>
        <p>Question text</p>

        <div class="option1 correct">
            <input id="q11" name="q1" value="1" type="checkbox" autocomplete="off">
            <label for="q11">&nbsp;<strong>Answer 1</strong></label>
        </div>
        <div class="option1">
            <input id="q12" name="q1" value="2" type="checkbox" autocomplete="off">
            <label for="q12">&nbsp;<strong>Answer 2</strong></label>
        </div>
        <br>

        <button onclick="checkbox_question(1)">Done!</button>

        <div id="feedback1" style="display:none">
            <br>
            <p class="response">
                <strong>The correct answer(s) is/are:</strong> a), b)<br> Explanation of the answer.
            </p>
            <br>
        </div><!-- end answer -->

    </div><!-- end question_wrap -->

</div>*/