

//The following three functions handle Popups with text only

function Fb_Correct(Text)
	{
	Feedback(Text,'Correct');
	}

function Fb_Wrong(Text)
	{
	Feedback(Text,'Wrong');
	}

function Feedback(Text,Status)
	{
	var Feedback_Text = document.createTextNode(Text);

	var Feedback_Text_Area = document.createElement("div");
	Feedback_Text_Area.appendChild(Feedback_Text);

	if(!Status)
		Status = "Blue";

	FeedbackPopUp(Feedback_Text_Area,'NoImage',Status);
	}


//The following three functions handle Popups with text and images

function Fb_Im_Correct(Text,Image_Name)
	{
	Feedback_Image(Text,Image_Name,'Correct');
	}

function Fb_Im_Wrong(Text,Image_Name)
	{
	Feedback_Image(Text,Image_Name,'Wrong');
	}

function Feedback_Image(Text,Image_Name,Status)
	{
	var Feedback_Text = document.createTextNode(Text);
		var Feedback_Text_Area = document.createElement("div");
		Feedback_Text_Area.appendChild(Feedback_Text);

	var Image = document.createElement("img");
		var Source = "images/" + Image_Name;
		Image.setAttribute("src", Source);
		Image.setAttribute("id","Fb_Image");

	FeedbackPopUp(Feedback_Text_Area,Image,Status);
	}

//The following function creates, positions, etc. the Popup window

function FeedbackPopUp(Feedback_Text_Area,Image,Status)
	{

	//Removes an old Feedback
	if(document.getElementById("Feedback"))
		Remove_Area("Feedback","Document");

	//Creates the Feedback Window itself
	var Feedback_Window = document.createElement("div");
	Feedback_Window.setAttribute("id", "Feedback");

	//Creates the black area on top
		var Closing_Space = document.createElement("div");
			Closing_Space.setAttribute("id","Header");
			Closing_Space.style.backgroundColor = "black";

 	//Creates the closing button
	var Form_Element = document.createElement("form");
		var Button = document.createElement("button");
			Button.setAttribute("id","CloseButton");
			var Buttontext = document.createTextNode("X");
			var Buttondiv = document.createElement("div");
			Buttondiv.appendChild(Buttontext);
			Button.appendChild(Buttondiv);
			Buttondiv.style.fontWeight = "bolder";
			Buttondiv.style.width = "20px";
			Form_Element.appendChild(Button);

	Closing_Space.appendChild(Form_Element);

	Feedback_Window.appendChild(Closing_Space);

	Feedback_Window.appendChild(Feedback_Text_Area);

	if(Image != "NoImage")
		{
		Feedback_Window.appendChild(Image);
		Feedback_Window.style.width = "550px";
		}
	else
		{
		Feedback_Window.style.width = "60%";
		Feedback_Window.style.marginLeft = "-30%";
		}

	document.getElementById("Document").appendChild(Feedback_Window);

	document.getElementById("CloseButton").onclick = Remove_Feedback;
	document.getElementById("CloseButton").onmousedown = Remove_Feedback;
	document.getElementById("Header").onmousedown = Init;

	if(window.netscape)
		Feedback_Window.setAttribute("class", "Feedback");
	else
		document.all.Feedback.className = "Feedback";

	if(Status == "Correct")
		document.getElementById("Feedback").style.backgroundImage = "url(images/bggreen.jpg)";

	if(Status == "Blue")
		document.getElementById("Feedback").style.backgroundImage = "url(images/bgblue.jpg)";
	}

function Remove_Feedback()
	{
	Remove_Area('Feedback','Document');
	}


//The following functions handle moving the Feedback Window around

var xDist;
var yDist;
var xWindow_Position;
var yWindow_Position;
var xDocument_Position;
var yDocument_Position;

//Gets various things regarding the position of the mouse, Feedback, etc.

function Init(evt)
	{
	if(window.netscape)
		{
		xDist = evt.layerX;
		yDist = evt.layerY;
		}
	else
		{
		xDist = window.event.offsetX;
		yDist = window.event.offsetY;
		xWindow_Position =  window.event.clientX - xDist;
		yWindow_Position = window.event.clientY - yDist;
		xDocument_Position = document.all.Feedback.offsetLeft;
		yDocument_Position = document.all.Feedback.offsetTop;
		document.getElementById("Feedback").style.left = xDocument_Position;
		document.getElementById("Feedback").style.top = yDocument_Position;
		}
	document.onmousemove = Move_Feedback;
	document.onmouseup = Stop;
	}

//Changes the position of the Feedback

function Move_Feedback(evt)
	{
	if(window.netscape)
		{
		var xCoordinate = evt.pageX - xDist;
		var yCoordinate = evt.pageY - yDist;
		if (xCoordinate <0)
			xCoordinate = 0;
		if (yCoordinate<0)
			yCoordinate = 0;
		document.getElementById("Feedback").style.left = xCoordinate;
		document.getElementById("Feedback").style.top = yCoordinate;
		}
	else
		{
		var xCoordinate = window.event.clientX - xWindow_Position - xDist;
		var yCoordinate = window.event.clientY - yWindow_Position - yDist;
		if(xDocument_Position + xCoordinate<0)
			xCoordinate = -xDocument_Position ;
		if (yDocument_Position + yCoordinate<0)
			yCoordinate = -yDocument_Position;
		document.getElementById("Feedback").style.left = xDocument_Position + xCoordinate;
		document.getElementById("Feedback").style.top = yDocument_Position + yCoordinate;
		}

	}

//Stops the Movement

//Top be added: final dropping of the Feedback

function Stop()
	{
	document.onmousemove = null;
	}

// JavaScripts for questions qith answers using checkboxes

function Choice(Number,Status)
	{
	if(document.forms[Number].elements[0].checked == true)
		{
		var Text = document.forms[Number].elements[0].value;
		if(Status == "Correct")
				Fb_Correct(Text);

		else
				{
				Fb_Wrong(Text);
				document.forms[Number].elements[0].checked=false;
				}
		}
	}

function Initialize()
	{
	var Number = document.forms.length;
	for(var i = 0; i < Number; i++)
		{
		Clear(i);
		}
	}
	
function Clear(Div_Id)
	{
	document.getElementById(Div_Id).reset();
	}
