/* ---------------------------------------------
expandAll v.1.3.1
http://adipalaz.awardspace.com/experiments/jquery/expand.html
Requires: jQuery v1.3+
Copyright (c) 2009 Adriana Palazova
Dual licensed under the MIT (http://adipalaz.awardspace.com/docs/mit-license.txt) and GPL (http://adipalaz.awardspace.com/docs/gpl-license.txt) licenses.
------------------------------------------------ */
(function($) {
$.fn.expandAll = function(options) {
    var defaults = {
         expTxt : '[Expand All]',
         cllpsTxt : '[Collapse All]',
         cllpsEl : '.collapse', // the collapsible element
         trigger : '.expand', // the elements that trigger the toggle action on the individual collapsible sections
         ref : '.expand', // the switch 'Expand All/Collapse All' is inserted before the 'ref'
         showMethod : 'show',
         hideMethod : 'hide',
         state : 'hidden', // the collapsible elements are hidden by default
         speed : 0
    };
    var o = $.extend({}, defaults, options);   
    
    var toggleTxt = o.expTxt;
    if (o.state == 'hidden') {$(this).find(o.cllpsEl).hide();} else {toggleTxt = o.cllpsTxt;}
    
    return this.each(function(index) {
        var container;
        if (this.id.length) {
          container = '#' + this.id;
        } else if (this.className.length){
          container = this.tagName.toLowerCase() + '.' + this.className.split(' ').join('.');
        } else {container = this.tagName.toLowerCase();}

        $(this).find(o.ref + ':first').before('<p class="switch"><a href="#">' + toggleTxt + '</a></p>');
        $(this).find('p.switch a').click(function() {
        var $cllps = $(this).closest(container).find(o.cllpsEl),
            $tr = $(this).closest(container).find(o.trigger);
        if ($(this).text() == o.expTxt) {
          $(this).text(o.cllpsTxt);
          $tr.addClass('open');
          $cllps[o.showMethod](o.speed);
        } else {
          $(this).text(o.expTxt);
          $tr.removeClass('open');
          $cllps[o.hideMethod](o.speed);
        }
        return false;
    });
});};
/* ---------------------------------------------
Toggler
http://adipalaz.awardspace.com/experiments/jquery/expand.html
When using this script, please keep the above url intact.
------------------------------------------------ */
$.fn.toggler = function(options) {
    var defaults = {
         cllpsEl : 'div.collapse',
         method : 'slideToggle',
         speed : 'slow',
         container : '', //the common container of all groups with collapsible content (optional)
         initShow : '.shown' //the initially expanded sections (optional)
    };
    var o = $.extend({}, defaults, options);
    
    $(this).wrapInner('<a style="display:block" href="#" title="Expand/Collapse" />');
    return this.each(function() {
      var container;
      (o.container) ? container = o.container : container = 'div';
      if (o.initShow) {
        $(this).closest(container).find(o.initShow).show().prev().addClass('open');
      }
      $(this).click(function() {
          $(this).toggleClass('open')
          .next(o.cllpsEl)[o.method](o.speed);
          return false;
    });
});};
//http://www.learningjquery.com/2008/02/simple-effects-plugins:
$.fn.fadeToggle = function(speed, easing, callback) {
    return this.animate({opacity: 'toggle'}, speed, easing, callback);
};
$.fn.slideFadeToggle = function(speed, easing, callback) {
    return this.animate({opacity: 'toggle', height: 'toggle'}, speed, easing, callback);
};
})(jQuery);



$(function() {
    $("#content").expandAll({trigger: "h4.expand", ref: "div.demo", showMethod: "slideDown", hideMethod: "slideUp", speed: 400});
    // --- Using the default options:
    $("h4.expand").toggler();
    // --- Other options:
    //$("h2.expand").toggler({method: "toggle", speed: 0});
    //$("h2.expand").toggler({method: "toggle"});
    //$("h2.expand").toggler({speed: "fast"});
    //$("h2.expand").toggler({method: "fadeToggle"});
    //$("h2.expand").toggler({method: "slideFadeToggle"});    
});
